var samplePageObj = {
  // 샘플 타이틀
  title: 'Master/Detail 형태 조회',
  subtitle: '두 개의 시트를 이용하여 한 시트의 행 이동 시, 다른 시트의 데이터를 로드하는 방법을 알아봅니다.',
  // 샘플 설명
  desc: '화면에 두 개의 시트(Master 시트, Detail 시트)가 있고 Master 시트의 행을 이동할 경우 onFocus 이벤트를 통해 Detail 시트에 데이터를 조회할 수 있습니다.<br>'
  + 'Master 시트의 행 이동 전, onBeforeFocus 이벤트에서 Detail 시트의 변경 여부를 검사합니다.<br>'
  + '서버 저장 요청 시, 두 시트의 필수 입력 항목과 수정 사항이 존재하는지를 getSaveJson 함수를 통해 검사합니다.<br>'
  + '두 시트의 검증이 끝난 후, ajax 함수를 이용하여 두 시트의 데이터를 동시에 보냅니다.',

  // 객체 초기화 구문
  init: {
    LeftSheetInit: {
      Def: {},
      Cfg: {
        SearchMode: 0
      },
      LeftCols: [],
      Cols: [
        {
          Header: {
            Value: '시도명'
          },
          Name: 'sSido',
          Required: 1,
          RelWidth: 1,
          Type: 'Text',
          Align: 'Center'
        },
        {
          Header: {
            Value: '시군구명'
          },
          Name: 'sSiGunGu',
          Required: 1,
          RelWidth: 1,
          Type: 'Text',
          Align: 'Center'
        }
      ]
    },
    RightSheetInit: {
      Def: {},
      Cfg: {
        SearchMode: 0,
        IgnoreFocused: true
      },
      LeftCols: [],
      Cols: [
        {
          Header: '도서관명',
          Type: 'Text',
          Name: 'sName',
          Required: 1,
          MinWidth: 150
        },
        {
          Header: '도서관유형',
          Type: 'Enum',
          Name: 'sType',
          MinWidth: 100,
          CanEdit: 1,
          Enum: '|공공도서관|작은도서관',
          EnumKeys: '|1|2'
        },
        {
          Header: '평일운영시작시각',
          Name: 'sWeekdayStart',
          MinWidth: 100,
          Type: 'Date',
          Format: 'HH:mm'
        },
        {
          Header: '평일운영종료시각',
          Name: 'sWeekdayEnd',
          MinWidth: 100,
          Type: 'Date',
          Format: 'HH:mm',
          CanEdit: 1
        },
        {
          Header: '토요일운영시작시각',
          Name: 'sSaturdayStart',
          MinWidth: 100,
          Type: 'Date',
          Format: 'HH:mm'
        },
        {
          Header: '토요일운영종료시각',
          Name: 'sSaturdayEnd',
          MinWidth: 100,
          Type: 'Date',
          Format: 'HH:mm'
        },
        {
          Header: '공휴일운영시작시각',
          Name: 'sHolidayStart',
          MinWidth: 100,
          Type: 'Date',
          Format: 'HH:mm'
        },
        {
          Header: '공휴일운영종료시각',
          Name: 'sHolidayEnd',
          MinWidth: 100,
          Type: 'Date',
          Format: 'HH:mm'
        },
        {
          Header: '휴관일',
          Type: 'Lines',
          Name: 'sClosed',
          MinWidth: 200
        },
        {
          Header: '자료수(도서)',
          Type: 'Int',
          Name: 'sBook',
          MinWidth: 100,
          Format: '#,##0 권'
        },
        {
          Header: '자료수(연속간행물)',
          Type: 'Int',
          Name: 'sSeries',
          MinWidth: 100,
          Format: '#,##0 종'
        },
        {
          Header: '자료수(비도서)',
          Type: 'Int',
          Name: 'sNonbook',
          MinWidth: 100,
          Format: '#,##0 종'
        },
        {
          Header: '대출가능권수',
          Type: 'Int',
          Name: 'sRentNum',
          MinWidth: 50,
          CanEdit: 1,
          Format: '#,### 권'
        },
        {
          Header: '대출가능일수',
          Type: 'Int',
          Name: 'sRentDay',
          MinWidth: 50,
          CanEdit: 1,
          Format: '#,### 일'
        },
        {
          Header: '시군구명',
          Name: 'sSiGunGu',
          MinWidth: 100,
          Type: 'Text',
          Align: 'Center'
        }
      ]
    }
  },

  // 버튼/기능 영역 html (sampleBtn으로 호출하면 action함수로 연결)
  func: '<div><button class=\'mgr10\' onclick=\'sampleBtn(this,1)\'>저장 성공</button> <button onclick=\'sampleBtn(this,0)\'>저장 실패</button></div>',

  // 객체 생성 Html
  objEl: '<div style=\'height:100%;\'>'
        + '<div id=\'LeftSheetDiv\' style=\'float:left;width:29%;height:100%\'></div>'
        + '<div style=\'float:left;width:2%;height:100%\'></div>'
        + '<div id=\'RightSheetDiv\' style=\'float:left;width:69%;height:100%\'></div>'
        + '</div>',

  // 시트 하단 영역 html
  footer: '<span></span>',

  // 객체 생성 구문
  create: function () {
    var options1 = this.init.LeftSheetInit;

    options1.Events = this.event;
    IBSheet.create({
      id: 'LeftSheet', // 생성할 시트의 id
      el: 'LeftSheetDiv', // 시트를 생성할 Dom 객체 및 id
      options: options1, // 생성될 시트의 속성
      data: this.data.LeftSheetData // 생성될 시트의 정적데이터
    });

    var options2 = this.init.RightSheetInit;

    IBSheet.create({
      id: 'RightSheet', // 생성할 시트의 id
      el: 'RightSheetDiv', // 시트를 생성할 Dom 객체 및 id
      options: options2, // 생성될 시트의 속성
      data: this.data.RightSheetData.gwanak // 생성될 시트의 정적데이터
    });
  },
  // 버튼 클릭시 기능 로직
  action: function () {
    if (arguments[0].innerText.match('저장')) {
      var url = arguments[1] === 1 ? '/save_success.jsp' : '/save_error.jsp';

      if (location.href.indexOf('localhost') > -1) {
        url = '../jsp/samples/customer' + url;
      } else {
        url = 'https://api.ibleaders.com/ibsheet/v8/samples/customer' + url;
      }

      var leftSheetChanges = LeftSheet.getSaveJson();
      var rightSheetChanges = RightSheet.getSaveJson();

      // master 시트 필수 입력 항목 검사
      if (leftSheetChanges.Message && leftSheetChanges.Message === 'RequiredError') {
        var msg = LeftSheet.getMessage('RequiredError');
        var rowIdx = LeftSheet.getRowIndex(leftSheetChanges.row);
        var colIdx = LeftSheet.getColIndex(leftSheetChanges.col);

        LeftSheet.showMessageTime({
          message: msg.replace('%1', rowIdx).replace('%2', colIdx),
          buttons: ['확인']
        });

        return;
      }

      // detail 시트 필수 입력 항목 검사
      if (rightSheetChanges.Message && rightSheetChanges.Message === 'RequiredError') {
        var msg = RightSheet.getMessage('RequiredError');
        var rowIdx = RightSheet.getRowIndex(rightSheetChanges.row);
        var colIdx = RightSheet.getColIndex(rightSheetChanges.col);

        RightSheet.showMessageTime({
          message: msg.replace('%1', rowIdx).replace('%2', colIdx),
          buttons: ['확인']
        });

        return;
      }

      // 두 시트 모두 변경 사항이 없으면 경고창을 띄웁니다.
      if (leftSheetChanges.data.length === 0 && rightSheetChanges.data.length === 0) {
        var msg = LeftSheet.getMessage('NoSave');

        LeftSheet.showMessageTime({
          message: msg,
          buttons: ['확인']
        });

        RightSheet.showMessageTime({
          message: msg,
          buttons: ['확인']
        });

        return;
      }

      // 두 시트 데이터를 서버로 저장 요청을 보내는 로직
      LeftSheet.ajax({
        url: url,
        param: {
          leftSheetData: leftSheetChanges.data,
          rightSheetData: rightSheetChanges.data
        },
        method: 'POST',
        reqHeader: { 'Content-Type': 'application/json' },
        callback: function (res, data, resXml, response) {
          var dataJson = JSON.parse(data);
          var msg;

          if (dataJson.IO.Result >= 0) {
            msg = '저장 성공';

            if (leftSheetChanges.data.length > 0) {
              LeftSheet.applySaveResult(dataJson.IO.Result);
            }
            if (rightSheetChanges.data.length > 0) {
              RightSheet.applySaveResult(dataJson.IO.Result);
            }
          } else {
            msg = '저장 실패';
          }

          if (leftSheetChanges.data.length > 0) {
            LeftSheet.showMessageTime({
              message: msg,
              buttons: ['확인']
            });
          }

          if (rightSheetChanges.data.length > 0) {
            RightSheet.showMessageTime({
              message: msg,
              buttons: ['확인']
            });
          }
        }
      });
    }
  },

  // event구문
  event: {
    onBeforeFocus: function (evtParam) {
      console.log(evtParam.eventName + ' 발생');
      // 동일한 행 클릭 시, 검사를 진행하지 않습니다.
      if (evtParam.orow && evtParam.row !== evtParam.orow) {
        var rightSheetChanges = RightSheet.getSaveJson();

        // master 시트 포커스 이동 시, detail 시트에 필수 항목 입력 여부 검사
        if (rightSheetChanges.Message && rightSheetChanges.Message === 'RequiredError') {
          var msg = RightSheet.getMessage('RequiredError');
          var rowIdx = RightSheet.getRowIndex(rightSheetChanges.row);
          var colIdx = RightSheet.getColIndex(rightSheetChanges.col);

          RightSheet.showMessageTime({
            message: msg.replace('%1', rowIdx).replace('%2', colIdx),
            buttons: ['확인']
          });

          return true; // true를 리턴하면 포커스를 이동하지 않습니다.
        }

        if (rightSheetChanges.data.length > 0) {
          if (!confirm('수정된 데이터가 존재합니다. 이동하시겠습니까?\n(이동 시 수정된 데이터는 저장되지 않습니다.)')) {
            return true; // true를 리턴하면 포커스를 이동하지 않습니다.
          }
        }
      }
    },
    onFocus: function (evtParam) {
      // 최초 시트 생성 시 데이터 로드 방지 및 기존에 선택되었던 행 반복 선택 방지
      if (evtParam.orow && evtParam.row !== evtParam.orow) {
        // master 시트에서 선택된 셀의 내용에 따라서 detail 시트의 데이터 로드
        var sigun = evtParam.row.sSiGunGu;
        var data = samplePageObj.data.RightSheetData;

        switch (sigun) {
          case '관악구':
            RightSheet.loadSearchData(data.gwanak);
            break;
          case '광진구':
            RightSheet.loadSearchData(data.gwangjin);
            break;
          case '금천구':
            RightSheet.loadSearchData(data.geumcheon);
            break;
          case '동작구':
            RightSheet.loadSearchData(data.dongjak);
            break;
          case '서초구':
            RightSheet.loadSearchData(data.seocho);
            break;
          case '송파구':
            RightSheet.loadSearchData(data.songpa);
            break;
          default:
            break;
        }
      }
    }
  },

  // data
  data: {
    LeftSheetData: [
      {
        sSido: '서울특별시',
        sSiGunGu: '관악구'
      },
      {
        sSido: '서울특별시',
        sSiGunGu: '광진구'
      },
      {
        sSido: '서울특별시',
        sSiGunGu: '금천구'
      },
      {
        sSido: '서울특별시',
        sSiGunGu: '동작구'
      },
      {
        sSido: '서울특별시',
        sSiGunGu: '서초구'
      },
      {
        sSido: '서울특별시',
        sSiGunGu: '송파구'
      },
    ],
    RightSheetData: {
      gwanak: [
        {
          sName: '책쉼터',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:56',
          sSaturdayEnd: '06:56',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '매주 일요일/국가지정공휴일',
          sBook: 3870,
          sSeries: 0,
          sNonbook: 0,
          sRentNum: 4,
          sRentDay: 14,
          sSiGunGu: '관악구'
        },
        {
          sName: '숲속작은도서관',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:58',
          sSaturdayEnd: '06:59',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '매주 화요일/국가지정공휴일',
          sBook: 3070,
          sSeries: 0,
          sNonbook: 0,
          sRentNum: 5,
          sRentDay: 14,
          sSiGunGu: '관악구'
        },
        {
          sName: '신림청소년독서실',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '07:00',
          sSaturdayStart: '06:58',
          sSaturdayEnd: '07:00',
          sHolidayStart: '06:58',
          sHolidayEnd: '07:00',
          sClosed: '매주 일요일/국가지정공휴일',
          sBook: 8000,
          sSeries: 0,
          sNonbook: 0,
          sRentNum: 3,
          sRentDay: 7,
          sSiGunGu: '관악구'
        },
        {
          sName: '관악문화관도서관',
          sType: '1',
          sWeekdayStart: '06:57',
          sWeekdayEnd: '07:00',
          sSaturdayStart: '06:58',
          sSaturdayEnd: '06:59',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '매주 화요일/국가지정공휴일',
          sBook: 192848,
          sSeries: 108,
          sNonbook: 26180,
          sRentNum: 5,
          sRentDay: 14,
          sSiGunGu: '관악구'
        },
        {
          sName: '글빛정보도서관',
          sType: '1',
          sWeekdayStart: '06:57',
          sWeekdayEnd: '07:00',
          sSaturdayStart: '06:58',
          sSaturdayEnd: '07:00',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '매주 수요일/국가지정공휴일',
          sBook: 63357,
          sSeries: 56,
          sNonbook: 2372,
          sRentNum: 5,
          sRentDay: 14,
          sSiGunGu: '관악구'
        },
        {
          sName: '성현동작은도서관',
          sType: '1',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:58',
          sSaturdayEnd: '06:59',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '매주 화요일/국가지정공휴일',
          sBook: 50271,
          sSeries: 44,
          sNonbook: 2038,
          sRentNum: 5,
          sRentDay: 14,
          sSiGunGu: '관악구'
        },
        {
          sName: '은천동작은도서관',
          sType: '1',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '07:00',
          sSaturdayStart: '06:58',
          sSaturdayEnd: '06:59',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '매주 화요일/국가지정공휴일',
          sBook: 44032,
          sSeries: 60,
          sNonbook: 1495,
          sRentNum: 5,
          sRentDay: 14,
          sSiGunGu: '관악구'
        },
        {
          sName: '조원작은도서관',
          sType: '1',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '07:00',
          sSaturdayStart: '06:58',
          sSaturdayEnd: '06:59',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '매주 수요일/법정공휴일',
          sBook: 57893,
          sSeries: 62,
          sNonbook: 4748,
          sRentNum: 5,
          sRentDay: 14,
          sSiGunGu: '관악구'
        },
        {
          sName: '책이랑놀이랑',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:58',
          sSaturdayEnd: '06:59',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '매주 화요일/국가지정공휴일',
          sBook: 13106,
          sSeries: 15,
          sNonbook: 468,
          sRentNum: 5,
          sRentDay: 14,
          sSiGunGu: '관악구'
        },
        {
          sName: '관악산 詩도서관',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:58',
          sSaturdayEnd: '06:59',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '매주 화요일/국가지정공휴일',
          sBook: 5901,
          sSeries: 0,
          sNonbook: 43,
          sRentNum: 5,
          sRentDay: 14,
          sSiGunGu: '관악구'
        },
        {
          sName: '낙성대공원도서관',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:58',
          sSaturdayEnd: '06:59',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '매주 화요일/국가지정공휴일',
          sBook: 6725,
          sSeries: 14,
          sNonbook: 102,
          sRentNum: 5,
          sRentDay: 14,
          sSiGunGu: '관악구'
        },
        {
          sName: '청림동 푸른숲작은도서관',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:56',
          sSaturdayEnd: '06:56',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '매주 토/일요일/국가지정공휴일',
          sBook: 7388,
          sSeries: 0,
          sNonbook: 7390,
          sRentNum: 5,
          sRentDay: 14,
          sSiGunGu: '관악구'
        },
        {
          sName: '행운동 마루작은도서관',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:56',
          sSaturdayEnd: '06:56',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '매주 토/일요일/국가지정공휴일',
          sBook: 5738,
          sSeries: 0,
          sNonbook: 5749,
          sRentNum: 5,
          sRentDay: 14,
          sSiGunGu: '관악구'
        },
        {
          sName: '청룡동 숯고을작은도서관',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:56',
          sSaturdayEnd: '06:56',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '매주 토/일요일/국가지정공휴일',
          sBook: 9520,
          sSeries: 2,
          sNonbook: 9564,
          sRentNum: 5,
          sRentDay: 14,
          sSiGunGu: '관악구'
        },
        {
          sName: '낙성동 우듬지작은도서관',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:56',
          sSaturdayEnd: '06:56',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '매주 토/일요일/국가지정공휴일',
          sBook: 6555,
          sSeries: 0,
          sNonbook: 6569,
          sRentNum: 5,
          sRentDay: 14,
          sSiGunGu: '관악구'
        },
        {
          sName: '미성동 책의향기작은도서관',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:56',
          sSaturdayEnd: '06:56',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '매주 토/일요일/국가지정공휴일',
          sBook: 7480,
          sSeries: 8,
          sNonbook: 7480,
          sRentNum: 5,
          sRentDay: 14,
          sSiGunGu: '관악구'
        },
        {
          sName: '삼성동 샛별작은도서관',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:56',
          sSaturdayEnd: '06:56',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '매주 토/일요일/국가지정공휴일',
          sBook: 7106,
          sSeries: 0,
          sNonbook: 7114,
          sRentNum: 5,
          sRentDay: 14,
          sSiGunGu: '관악구'
        }
      ],
      gwangjin: [
        {
          sName: '광진정보도서관',
          sType: '1',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '07:00',
          sSaturdayStart: '06:58',
          sSaturdayEnd: '06:59',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '매월 둘째, 넷째 화요일, 공휴일',
          sBook: 237257,
          sSeries: 380,
          sNonbook: 13965,
          sRentNum: 5,
          sRentDay: 21,
          sSiGunGu: '광진구'
        },
        {
          sName: '중곡문화체육센터도서관',
          sType: '1',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '07:00',
          sSaturdayStart: '06:58',
          sSaturdayEnd: '06:59',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '매월 첫째, 셋째 월요일, 공휴일',
          sBook: 73824,
          sSeries: 40,
          sNonbook: 0,
          sRentNum: 5,
          sRentDay: 21,
          sSiGunGu: '광진구'
        },
        {
          sName: '자양제4동도서관',
          sType: '1',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:58',
          sSaturdayEnd: '06:59',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '매월 첫째, 셋째 화요일, 공휴일',
          sBook: 26947,
          sSeries: 4,
          sNonbook: 0,
          sRentNum: 5,
          sRentDay: 21,
          sSiGunGu: '광진구'
        },
        {
          sName: '구의제3동도서관',
          sType: '1',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:58',
          sSaturdayEnd: '06:59',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '매월 둘째, 넷째 월요일, 공휴일',
          sBook: 25064,
          sSeries: 4,
          sNonbook: 0,
          sRentNum: 5,
          sRentDay: 21,
          sSiGunGu: '광진구'
        },
        {
          sName: '중곡1동새마을작은도서관',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:56',
          sSaturdayEnd: '06:56',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '매주 토요일, 일요일, 공휴일',
          sBook: 10619,
          sSeries: 0,
          sNonbook: 0,
          sRentNum: 5,
          sRentDay: 7,
          sSiGunGu: '광진구'
        },
        {
          sName: '중곡2동새마을작은도서관',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:56',
          sSaturdayEnd: '06:56',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '매주 토요일, 일요일, 공휴일',
          sBook: 5687,
          sSeries: 0,
          sNonbook: 0,
          sRentNum: 5,
          sRentDay: 7,
          sSiGunGu: '광진구'
        },
        {
          sName: '중곡3동새마을작은도서관',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:56',
          sSaturdayEnd: '06:56',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '매주 토요일, 일요일, 공휴일',
          sBook: 4335,
          sSeries: 0,
          sNonbook: 0,
          sRentNum: 3,
          sRentDay: 7,
          sSiGunGu: '광진구'
        },
        {
          sName: '중곡4동새마을작은도서관',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:56',
          sSaturdayEnd: '06:56',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '매주 토요일, 일요일, 공휴일',
          sBook: 5280,
          sSeries: 0,
          sNonbook: 0,
          sRentNum: 3,
          sRentDay: 7,
          sSiGunGu: '광진구'
        },
        {
          sName: '능동새마을작은도서관',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:56',
          sSaturdayEnd: '06:56',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '매주 토요일, 일요일, 공휴일',
          sBook: 7368,
          sSeries: 0,
          sNonbook: 0,
          sRentNum: 3,
          sRentDay: 7,
          sSiGunGu: '광진구'
        },
        {
          sName: '구의1동새마을작은도서관',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:56',
          sSaturdayEnd: '06:56',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '매주 토요일, 일요일, 공휴일',
          sBook: 5738,
          sSeries: 0,
          sNonbook: 0,
          sRentNum: 3,
          sRentDay: 7,
          sSiGunGu: '광진구'
        },
        {
          sName: '구의2동새마을작은도서관',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:56',
          sSaturdayEnd: '06:56',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '매주 토요일, 일요일, 공휴일',
          sBook: 5980,
          sSeries: 0,
          sNonbook: 0,
          sRentNum: 3,
          sRentDay: 7,
          sSiGunGu: '광진구'
        },
        {
          sName: '광장동새마을작은도서관',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:56',
          sSaturdayEnd: '06:56',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '매주 토요일, 일요일, 공휴일',
          sBook: 4641,
          sSeries: 0,
          sNonbook: 0,
          sRentNum: 3,
          sRentDay: 7,
          sSiGunGu: '광진구'
        },
        {
          sName: '자양1동새마을작은도서관',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:56',
          sSaturdayEnd: '06:56',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '매주 토요일, 일요일, 공휴일',
          sBook: 6413,
          sSeries: 0,
          sNonbook: 0,
          sRentNum: 5,
          sRentDay: 7,
          sSiGunGu: '광진구'
        },
        {
          sName: '자양2동새마을작은도서관',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:56',
          sSaturdayEnd: '06:56',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '매주 토요일, 일요일, 공휴일',
          sBook: 9626,
          sSeries: 0,
          sNonbook: 0,
          sRentNum: 5,
          sRentDay: 7,
          sSiGunGu: '광진구'
        },
        {
          sName: '자양3동새마을작은도서관',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:56',
          sSaturdayEnd: '06:56',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '매주 토요일, 일요일, 공휴일',
          sBook: 8405,
          sSeries: 0,
          sNonbook: 0,
          sRentNum: 4,
          sRentDay: 7,
          sSiGunGu: '광진구'
        },
        {
          sName: '자양4동새마을작은도서관',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:56',
          sSaturdayEnd: '06:56',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '매주 토요일, 일요일, 공휴일',
          sBook: 4345,
          sSeries: 0,
          sNonbook: 0,
          sRentNum: 3,
          sRentDay: 7,
          sSiGunGu: '광진구'
        },
        {
          sName: '화양동새마을작은도서관',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:56',
          sSaturdayEnd: '06:56',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '매주 토요일, 일요일, 공휴일',
          sBook: 9031,
          sSeries: 0,
          sNonbook: 0,
          sRentNum: 3,
          sRentDay: 7,
          sSiGunGu: '광진구'
        }
      ],
      geumcheon: [
        {
          sName: '금천구립시흥도서관',
          sType: '1',
          sWeekdayStart: '06:57',
          sWeekdayEnd: '07:00',
          sSaturdayStart: '06:57',
          sSaturdayEnd: '07:00',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '매월 첫째,셋째 금요일/법정 공휴일',
          sBook: 71317,
          sSeries: 64,
          sNonbook: 3881,
          sRentNum: 10,
          sRentDay: 14,
          sSiGunGu: '금천구'
        },
        {
          sName: '금천구립금나래도서관',
          sType: '1',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '07:00',
          sSaturdayStart: '06:58',
          sSaturdayEnd: '07:00',
          sHolidayStart: '06:58',
          sHolidayEnd: '06:59',
          sClosed: '매월 마지막주 일요일/신정(1.1), 설연휴, 추석연휴, 석가탄신일, 성탄절, 선거일',
          sBook: 70141,
          sSeries: 80,
          sNonbook: 3881,
          sRentNum: 10,
          sRentDay: 14,
          sSiGunGu: '금천구'
        },
        {
          sName: '금천구립가산도서관',
          sType: '1',
          sWeekdayStart: '06:57',
          sWeekdayEnd: '07:00',
          sSaturdayStart: '06:57',
          sSaturdayEnd: '07:00',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '매월 둘째,넷째 월요일/법정 공휴일',
          sBook: 74282,
          sSeries: 115,
          sNonbook: 8604,
          sRentNum: 10,
          sRentDay: 14,
          sSiGunGu: '금천구'
        },
        {
          sName: '금천구립독산도서관',
          sType: '1',
          sWeekdayStart: '06:57',
          sWeekdayEnd: '07:00',
          sSaturdayStart: '06:57',
          sSaturdayEnd: '07:00',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '매월 첫째,셋째 월요일/법정 공휴일',
          sBook: 112521,
          sSeries: 152,
          sNonbook: 10825,
          sRentNum: 10,
          sRentDay: 14,
          sSiGunGu: '금천구'
        },
        {
          sName: '해오름작은도서관',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '07:00',
          sSaturdayStart: '06:58',
          sSaturdayEnd: '06:59',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '일요일/법정공휴일',
          sBook: 8424,
          sSeries: 0,
          sNonbook: 0,
          sRentNum: 10,
          sRentDay: 14,
          sSiGunGu: '금천구'
        },
        {
          sName: '참새작은도서관',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '07:00',
          sSaturdayStart: '06:58',
          sSaturdayEnd: '06:59',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '일요일/법정공휴일',
          sBook: 5577,
          sSeries: 0,
          sNonbook: 0,
          sRentNum: 10,
          sRentDay: 14,
          sSiGunGu: '금천구'
        },
        {
          sName: '미래향기작은도서관',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '07:00',
          sSaturdayStart: '06:58',
          sSaturdayEnd: '06:59',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '일요일/법정공휴일',
          sBook: 2545,
          sSeries: 0,
          sNonbook: 0,
          sRentNum: 10,
          sRentDay: 14,
          sSiGunGu: '금천구'
        },
        {
          sName: '청개구리작은도서관',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '07:00',
          sSaturdayStart: '06:58',
          sSaturdayEnd: '06:59',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '월,일요일/법정공휴일',
          sBook: 10804,
          sSeries: 2,
          sNonbook: 0,
          sRentNum: 10,
          sRentDay: 14,
          sSiGunGu: '금천구'
        },
        {
          sName: '꿈씨어린이작은도서관',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '07:00',
          sSaturdayStart: '06:58',
          sSaturdayEnd: '06:59',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '일요일/법정공휴일',
          sBook: 16203,
          sSeries: 4,
          sNonbook: 0,
          sRentNum: 10,
          sRentDay: 14,
          sSiGunGu: '금천구'
        },
        {
          sName: '맑은누리작은도서관',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:56',
          sSaturdayEnd: '06:56',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '토,일요일/법정공휴일',
          sBook: 9514,
          sSeries: 0,
          sNonbook: 0,
          sRentNum: 10,
          sRentDay: 14,
          sSiGunGu: '금천구'
        },
        {
          sName: '꿈꾸는작은도서관',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:56',
          sSaturdayEnd: '06:56',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '토,일요일/법정공휴일',
          sBook: 6021,
          sSeries: 7,
          sNonbook: 0,
          sRentNum: 10,
          sRentDay: 14,
          sSiGunGu: '금천구'
        },
        {
          sName: '도란도란작은도서관',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '07:00',
          sSaturdayStart: '06:58',
          sSaturdayEnd: '06:59',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '토,일요일/법정공휴일',
          sBook: 9663,
          sSeries: 0,
          sNonbook: 0,
          sRentNum: 10,
          sRentDay: 14,
          sSiGunGu: '금천구'
        },
        {
          sName: '책읽는주민사랑방작은도서관',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:58',
          sSaturdayEnd: '06:59',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '일요일/법정공휴일',
          sBook: 3886,
          sSeries: 0,
          sNonbook: 0,
          sRentNum: 10,
          sRentDay: 14,
          sSiGunGu: '금천구'
        },
        {
          sName: '책이든거리작은도서관',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '07:00',
          sSaturdayStart: '06:56',
          sSaturdayEnd: '06:56',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '토,일요일/법정공휴일',
          sBook: 5091,
          sSeries: 0,
          sNonbook: 0,
          sRentNum: 10,
          sRentDay: 14,
          sSiGunGu: '금천구'
        },
        {
          sName: '책달샘숲속작은도서관',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:58',
          sSaturdayEnd: '06:59',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '월,일요일/법정공휴일',
          sBook: 2160,
          sSeries: 0,
          sNonbook: 0,
          sRentNum: 10,
          sRentDay: 14,
          sSiGunGu: '금천구'
        },
        {
          sName: '우리울 작은도서관',
          sType: '2',
          sWeekdayStart: '06:59',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:59',
          sSaturdayEnd: '06:59',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '일요일/법정공휴일',
          sBook: 1300,
          sSeries: 0,
          sNonbook: 0,
          sRentNum: 10,
          sRentDay: 14,
          sSiGunGu: '금천구'
        },
        {
          sName: '롯데캐슬1차 작은도서관',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:58',
          sSaturdayEnd: '06:59',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '일요일/법정공휴일',
          sBook: 2500,
          sSeries: 0,
          sNonbook: 0,
          sRentNum: 10,
          sRentDay: 14,
          sSiGunGu: '금천구'
        },
        {
          sName: '지혜의숲 작은도서관',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:56',
          sSaturdayEnd: '06:56',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '토요일/법정공휴일',
          sBook: 9071,
          sSeries: 0,
          sNonbook: 0,
          sRentNum: 10,
          sRentDay: 14,
          sSiGunGu: '금천구'
        },
        {
          sName: '책읽는마을 작은도서관',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:56',
          sSaturdayEnd: '06:56',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '토,일요일/법정공휴일',
          sBook: 6573,
          sSeries: 0,
          sNonbook: 0,
          sRentNum: 10,
          sRentDay: 14,
          sSiGunGu: '금천구'
        },
        {
          sName: '트리니티 작은도서관',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '07:00',
          sSaturdayStart: '06:58',
          sSaturdayEnd: '07:00',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '법정공휴일',
          sBook: 1320,
          sSeries: 0,
          sNonbook: 0,
          sRentNum: 10,
          sRentDay: 14,
          sSiGunGu: '금천구'
        },
        {
          sName: '산돌어린이도서관',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:58',
          sSaturdayEnd: '06:59',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '월요일/법정공휴일',
          sBook: 1400,
          sSeries: 0,
          sNonbook: 0,
          sRentNum: 10,
          sRentDay: 14,
          sSiGunGu: '금천구'
        },
        {
          sName: '소망의나무어린이 작은도서관',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:58',
          sSaturdayEnd: '06:59',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '법정공휴일',
          sBook: 6579,
          sSeries: 0,
          sNonbook: 0,
          sRentNum: 10,
          sRentDay: 14,
          sSiGunGu: '금천구'
        },
        {
          sName: '은행나무어린이도서관',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:58',
          sSaturdayEnd: '06:59',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '월요일/법정공휴일',
          sBook: 11101,
          sSeries: 0,
          sNonbook: 0,
          sRentNum: 10,
          sRentDay: 14,
          sSiGunGu: '금천구'
        },
        {
          sName: '나누리 작은도서관',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:56',
          sSaturdayEnd: '06:56',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '토,일요일/법정공휴일',
          sBook: 8232,
          sSeries: 0,
          sNonbook: 0,
          sRentNum: 10,
          sRentDay: 14,
          sSiGunGu: '금천구'
        },
        {
          sName: '길빛 작은도서관',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:58',
          sSaturdayEnd: '06:59',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '일요일/법정공휴일',
          sBook: 3000,
          sSeries: 0,
          sNonbook: 0,
          sRentNum: 10,
          sRentDay: 14,
          sSiGunGu: '금천구'
        },
        {
          sName: '샘솟는 작은도서관',
          sType: '2',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:56',
          sSaturdayEnd: '06:56',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '토,일요일/법정공휴일',
          sBook: 1700,
          sSeries: 0,
          sNonbook: 0,
          sRentNum: 10,
          sRentDay: 14,
          sSiGunGu: '금천구'
        },
        {
          sName: '와서 작은도서관',
          sType: '2',
          sWeekdayStart: '06:59',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:56',
          sSaturdayEnd: '06:56',
          sHolidayStart: '06:56',
          sHolidayEnd: '06:56',
          sClosed: '토,일요일/법정공휴일',
          sBook: 2039,
          sSeries: 0,
          sNonbook: 0,
          sRentNum: 10,
          sRentDay: 14,
          sSiGunGu: '금천구'
        }
      ],
      dongjak: [
        {
          sName: '사당솔밭도서관',
          sType: '1',
          sWeekdayStart: '09:00',
          sWeekdayEnd: '22:00',
          sSaturdayStart: '09:00',
          sSaturdayEnd: '17:00',
          sHolidayStart: '00:00',
          sHolidayEnd: '00:00',
          sClosed: '매주 월요일, 법정공휴일',
          sBook: 60107,
          sSeries: 47,
          sNonbook: 353,
          sRentNum: 5,
          sRentDay: 14,
          sSiGunGu: '동작구'
        },
        {
          sName: '동작상도국주도서관',
          sType: '1',
          sWeekdayStart: '09:00',
          sWeekdayEnd: '22:00',
          sSaturdayStart: '09:00',
          sSaturdayEnd: '17:00',
          sHolidayStart: '00:00',
          sHolidayEnd: '00:00',
          sClosed: '매주 월요일, 법정공휴일',
          sBook: 45625,
          sSeries: 13,
          sNonbook: 1172,
          sRentNum: 5,
          sRentDay: 14,
          sSiGunGu: '동작구'
        }
      ],
      seocho: [
        {
          sName: '서초구립반포도서관',
          sType: '1',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '07:00',
          sSaturdayStart: '06:58',
          sSaturdayEnd: '06:59',
          sHolidayStart: '06:58',
          sHolidayEnd: '06:59',
          sClosed: '매주월요일, 법정공휴일',
          sBook: 159223,
          sSeries: 120,
          sNonbook: 29054,
          sRentNum: 159223,
          sRentDay: 14,
          sSiGunGu: '서초구'
        },
        {
          sName: '서초구립내곡도서관',
          sType: '1',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '07:00',
          sSaturdayStart: '06:58',
          sSaturdayEnd: '06:59',
          sHolidayStart: '06:58',
          sHolidayEnd: '06:59',
          sClosed: '매주월요일, 법정공휴일',
          sBook: 37717,
          sSeries: 50,
          sNonbook: 926,
          sRentNum: 37717,
          sRentDay: 14,
          sSiGunGu: '서초구'
        },
        {
          sName: '서이도서관',
          sType: '1',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '07:00',
          sSaturdayStart: '06:58',
          sSaturdayEnd: '06:59',
          sHolidayStart: '06:58',
          sHolidayEnd: '06:59',
          sClosed: '매주월요일, 법정공휴일',
          sBook: 24930,
          sSeries: 12,
          sNonbook: 0,
          sRentNum: 24930,
          sRentDay: 14,
          sSiGunGu: '서초구'
        },
        {
          sName: '잠원도서관',
          sType: '1',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '07:00',
          sSaturdayStart: '06:58',
          sSaturdayEnd: '06:59',
          sHolidayStart: '06:58',
          sHolidayEnd: '06:59',
          sClosed: '매주월요일, 법정공휴일',
          sBook: 18657,
          sSeries: 12,
          sNonbook: 0,
          sRentNum: 18657,
          sRentDay: 14,
          sSiGunGu: '서초구'
        },
        {
          sName: '방배도서관',
          sType: '1',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '07:00',
          sSaturdayStart: '06:58',
          sSaturdayEnd: '06:59',
          sHolidayStart: '06:58',
          sHolidayEnd: '06:59',
          sClosed: '매주월요일, 법정공휴일',
          sBook: 12365,
          sSeries: 12,
          sNonbook: 0,
          sRentNum: 12365,
          sRentDay: 14,
          sSiGunGu: '서초구'
        },
        {
          sName: '서초그림책도서관',
          sType: '1',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '07:00',
          sSaturdayStart: '06:58',
          sSaturdayEnd: '06:59',
          sHolidayStart: '06:58',
          sHolidayEnd: '06:59',
          sClosed: '매주월요일, 법정공휴일',
          sBook: 10236,
          sSeries: 12,
          sNonbook: 216,
          sRentNum: 10236,
          sRentDay: 14,
          sSiGunGu: '서초구'
        }
      ],
      songpa: [
        {
          sName: '송파글마루도서관',
          sType: '1',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '07:00',
          sSaturdayStart: '06:58',
          sSaturdayEnd: '07:00',
          sHolidayStart: '06:58',
          sHolidayEnd: '07:00',
          sClosed: '매주월요일+국가지정공휴일',
          sBook: 66700,
          sSeries: 103,
          sNonbook: 2261,
          sRentNum: 5,
          sRentDay: 14,
          sSiGunGu: '송파구'
        },
        {
          sName: '송파어린이도서관',
          sType: '1',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:58',
          sSaturdayEnd: '06:59',
          sHolidayStart: '06:58',
          sHolidayEnd: '06:59',
          sClosed: '매주월요일+국가지정공휴일',
          sBook: 84582,
          sSeries: 43,
          sNonbook: 671,
          sRentNum: 5,
          sRentDay: 14,
          sSiGunGu: '송파구'
        },
        {
          sName: '거마도서관',
          sType: '1',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '07:00',
          sSaturdayStart: '06:58',
          sSaturdayEnd: '07:00',
          sHolidayStart: '06:58',
          sHolidayEnd: '07:00',
          sClosed: '국가지정공휴일+2째월요일+4째월요일',
          sBook: 43658,
          sSeries: 64,
          sNonbook: 425,
          sRentNum: 5,
          sRentDay: 14,
          sSiGunGu: '송파구'
        },
        {
          sName: '소나무언덕1호',
          sType: '1',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '07:00',
          sSaturdayStart: '06:58',
          sSaturdayEnd: '07:00',
          sHolidayStart: '06:58',
          sHolidayEnd: '07:00',
          sClosed: '매주월요일+국가지정공휴일',
          sBook: 18317,
          sSeries: 7,
          sNonbook: 156,
          sRentNum: 5,
          sRentDay: 14,
          sSiGunGu: '송파구'
        },
        {
          sName: '소나무언덕2호',
          sType: '1',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '07:00',
          sSaturdayStart: '06:58',
          sSaturdayEnd: '07:00',
          sHolidayStart: '06:58',
          sHolidayEnd: '07:00',
          sClosed: '매주월요일+국가지정공휴일',
          sBook: 22084,
          sSeries: 10,
          sNonbook: 192,
          sRentNum: 5,
          sRentDay: 14,
          sSiGunGu: '송파구'
        },
        {
          sName: '소나무언덕3호',
          sType: '1',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '07:00',
          sSaturdayStart: '06:58',
          sSaturdayEnd: '07:00',
          sHolidayStart: '06:58',
          sHolidayEnd: '07:00',
          sClosed: '매주월요일+국가지정공휴일',
          sBook: 24512,
          sSeries: 17,
          sNonbook: 221,
          sRentNum: 5,
          sRentDay: 14,
          sSiGunGu: '송파구'
        },
        {
          sName: '소나무언덕4호',
          sType: '1',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '07:00',
          sSaturdayStart: '06:58',
          sSaturdayEnd: '07:00',
          sHolidayStart: '06:58',
          sHolidayEnd: '07:00',
          sClosed: '매주월요일+국가지정공휴일',
          sBook: 16988,
          sSeries: 30,
          sNonbook: 312,
          sRentNum: 5,
          sRentDay: 14,
          sSiGunGu: '송파구'
        },
        {
          sName: '소나무언덕 잠실본동',
          sType: '1',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:58',
          sSaturdayEnd: '06:59',
          sHolidayStart: '06:58',
          sHolidayEnd: '06:59',
          sClosed: '매주월요일+국가지정공휴일',
          sBook: 22534,
          sSeries: 29,
          sNonbook: 489,
          sRentNum: 5,
          sRentDay: 14,
          sSiGunGu: '송파구'
        },
        {
          sName: '송파어린이영어',
          sType: '1',
          sWeekdayStart: '06:58',
          sWeekdayEnd: '06:59',
          sSaturdayStart: '06:58',
          sSaturdayEnd: '06:59',
          sHolidayStart: '06:58',
          sHolidayEnd: '06:59',
          sClosed: '매주월요일+국가지정공휴일',
          sBook: 18508,
          sSeries: 11,
          sNonbook: 774,
          sRentNum: 5,
          sRentDay: 14,
          sSiGunGu: '송파구'
        }
      ]
    }
  }
};

var sampleBtn = function () {
  var args = Array.prototype.slice.call(arguments, 0);

  samplePageObj.action.apply(null, args);
};
